// Komunikacija po protokolu gRPC
// odjemalec

package main

import (
	"api/grpc/protobufStorage"
	"context"
	"fmt"
	"time"
	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials/insecure"
	"io"
	"google.golang.org/protobuf/types/known/emptypb"
	"sync"
	"log"
)

func Client(url string) {
	// vzpostavimo povezavo s strežnikom
	fmt.Printf("gRPC client connecting to %v\n", url)
	conn, err := grpc.NewClient(url, grpc.WithTransportCredentials(insecure.NewCredentials()))
	if err != nil {
		panic(err)
	}
	defer conn.Close()

	// vzpostavimo izvajalno okolje
	contextCRUD, cancel := context.WithCancel(context.Background()) // no timeout
	defer cancel()

	// vzpostavimo vmesnik gRPC
	grpcClient := protobufStorage.NewCRUDClient(conn)

	// pripravimo strukture, ki jih uporabljamo kot argumente pri klicu oddaljenih metod
	lecturesCreate := protobufStorage.Todo{Task: "predavanja", Completed: false}
	lecturesUpdate := protobufStorage.Todo{Task: "predavanja", Completed: true}
	homeworkCreate := protobufStorage.Todo{Task: "domaca naloga", Completed: true} // dodamo domačo nalogo
	practicals := protobufStorage.Todo{Task: "vaje", Completed: false}
	readAll := protobufStorage.Todo{Task: "", Completed: false}

	var wg sync.WaitGroup
	wg.Add(1)
	go func () {
		defer wg.Done()
		contextCRUD, cancel := context.WithCancel(context.Background()) // no timeout
		defer cancel()
		grpcClient := protobufStorage.NewCRUDClient(conn)
		for i := 0; i <= 5; i++ {
			// ustvarimo zapis
			log.Println("ustvarjam lectures")
			if _, err := grpcClient.Create(contextCRUD, &lecturesCreate); err != nil {
				panic(err)
			}

			// preberemo en zapis
			log.Println("berem en zapis")
			if response, err := grpcClient.Read(contextCRUD, &lecturesCreate); err == nil {
				log.Println("prebran zapis je", response.Todos, ": done")
			} else {
				panic(err)
			}

			// ustvarimo zapis
			log.Println("ustvarjam zapis practicals")
			if _, err := grpcClient.Create(contextCRUD, &practicals); err != nil {
				panic(err)
			}
			log.Println("ustvaril zapis practicals")

			// preberemo vse zapise
			log.Println("berem vse zapise")
			if response, err := grpcClient.Read(contextCRUD, &readAll); err == nil {
				log.Println("prebrani vsi zapisi so", response.Todos, ": done")
			} else {
				panic(err)
			}

			// posodobimo zapis
			log.Println("posodabljam zapis lectures")
			if _, err := grpcClient.Update(contextCRUD, &lecturesUpdate); err != nil {
				panic(err)
			}
			log.Println("posodobil zapis lectures")

			// izbrišemo zapis
			log.Println("brišem zapis practicals")
			if _, err := grpcClient.Delete(contextCRUD, &practicals); err != nil {
				panic(err)
			}
			log.Println("zbrisal zapis practicals")
			time.Sleep(time.Second)
		}
		log.Println("konec gorutine")
	}()
	// preberemo vse zapise
	// fmt.Print("7. Read *: ")
	// if response, err := grpcClient.Read(contextCRUD, &readAll); err == nil {
	// 	fmt.Println(response.Todos, ": done")
	// } else {
	// 	panic(err)
	// }
	log.Println("izdelujem zapis homework")
	if _, err := grpcClient.Create(contextCRUD, &homeworkCreate); err != nil {
	    panic(err)
	}
	log.Println("izdelal zapis homework")
	// preberemo vse zapise stream
	log.Println("pretočno berem vse zapise")
	if stream, err := grpcClient.ReadAll(contextCRUD, &emptypb.Empty{}); err == nil {
	    for {
		todo, err := stream.Recv()
		if err == io.EOF {
		    break
		}
		log.Println("pretočno prebral zapis", todo)
	    }
	} else {
	    panic(err)
	}
	log.Print("naročam se na spremembe")
	if stream, err := grpcClient.Subscribe(contextCRUD, &emptypb.Empty{}); err == nil {
		for {
			dogodek, err := stream.Recv()
			if err == io.EOF {
				break
			} else if err != nil {
				log.Println("nepričakovan stream.Recv err:", err)
				panic(err)
			}
			log.Println("prejel spremembo", dogodek.Action, dogodek.T)
		}
	} else {
		panic(err)
	}
	log.Println("končujem")
	wg.Wait()
	log.Println("wg waited")
}
